@echo off
TITLE PHANTOM PROXY - SETUP ASSISTANT
COLOR 0B

echo ======================================================
echo          PHANTOM PROXY SETUP ASSISTANT
echo ======================================================
echo.
echo [*] Checking System Configuration...

:: Check if Python is installed
python --version >nul 2>&1
if %errorlevel% neq 0 (
    echo [!] ERROR: Python is not installed on your system!
    echo.
    echo [!] Please download and install Python from:
    echo     https://www.python.org/downloads/
    echo.
    echo [*] Opening Python Download Page...
    start https://www.python.org/downloads/
    pause
    exit /b
)

:: Get Python version
for /f "tokens=2" %%v in ('python --version') do set pyver=%%v
echo [+] Python Found: v%pyver%

echo [*] Initializing Dependency Installation...
echo [*] Installing required modules (This may take a moment)...

:: Install pycryptodome
python -m pip install --upgrade pip >nul 2>&1
python -m pip install pycryptodome

if %errorlevel% neq 0 (
    echo.
    echo [!] ERROR: Failed to install dependencies.
    echo [!] Please ensure you have an active internet connection.
    pause
    exit /b
)

echo.
echo [+] Dependencies installed successfully.
echo [*] Finalizing setup...

:: Create setup flag file
echo Setup completed on %date% at %time% > setup_done.flag

echo.
echo ======================================================
echo          SETUP COMPLETED SUCCESSFULLY!
echo ======================================================
echo.
echo [!] You can now run 'proxy_bot.py' or 'START_BOT.bat'.
echo.
pause
exit /b
